import { useLocation } from 'react-router-dom';
import { ProfileHeader, ProfileAbout, ProfileGallery, ProfileInterests } from '../../components/Profile';

export const ViewProfile = () => {
  // Get profile data from navigation state
  const { state } = useLocation();
  const profile = state?.profile;

  // If no profile data, redirect or show loading
  if (!profile) {
    return (
      <div className="flex items-center justify-center h-screen">
        <p className="text-gray-400">Profile not found</p>
      </div>
    );
  }

  return (
    <div className="container mx-auto px-4 py-8">
      <ProfileHeader user={profile} />
      
      <div className="grid grid-cols-1 lg:grid-cols-3 gap-6 mt-6">
        <div className="lg:col-span-2 space-y-6">
          <ProfileAbout user={profile} />
          <ProfileGallery photos={profile.photos || []} />
        </div>
        
        <div className="space-y-6">
          <ProfileInterests interests={profile.interests} />
          
          {/* Compatibility Meter */}
          <div className="glass-effect p-6 rounded-2xl">
            <h2 className="text-xl font-semibold mb-4 text-cyan-400">Compatibility</h2>
            <div className="h-3 bg-[rgba(255,255,255,0.1)] rounded-full overflow-hidden">
              <div 
                className="h-full bg-gradient-to-r from-cyan-400 to-purple-500" 
                style={{ width: `${profile.compatibility}%` }}
              />
            </div>
            <p className="mt-2 text-sm text-gray-400">
              {profile.compatibility}% match based on your preferences
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};