import { motion } from "framer-motion";
import { Link } from "react-router-dom";

export const ProfileCard = ({ profile }) => {
  return (
    <motion.div 
      className="relative bg-[rgba(255,255,255,0.05)] border border-[rgba(255,255,255,0.1)] rounded-2xl overflow-hidden backdrop-blur-lg hover:shadow-neon-cyan transition-all duration-300"
      whileHover={{ y: -5 }}
    >
      <Link 
        to={`/profile/${profile.id}`}
        state={{ profile }} // Pass entire profile object
        className="block"
      >
        <div className="absolute inset-0 bg-gradient-to-br from-[rgba(0,240,255,0.03)] to-[rgba(123,77,255,0.03)]" />
        
        <div className="relative p-6">
          {/* Profile Image */}
          <div className="flex justify-center mb-4">
            <div className="relative">
              <img 
                src={profile.photos[0]} 
                className="w-24 h-24 rounded-full object-cover border-2 border-[rgba(0,240,255,0.3)]"
                alt={profile.name}
              />
              <div className="absolute -bottom-1 -right-1 w-6 h-6 bg-green-500 rounded-full border-2 border-[#0A0F2A]"></div>
            </div>
          </div>
          
          {/* Profile Info */}
          <div className="text-center">
            <h3 className="text-xl font-semibold text-white">{profile.name}, {profile.age}</h3>
            <p className="text-sm text-cyan-400">{profile.profession}</p>
            <p className="text-xs text-gray-400 mt-1">{profile.location}</p>
            
            {/* Compatibility */}
            <div className="mt-3">
              <div className="h-1.5 bg-[rgba(255,255,255,0.1)] rounded-full overflow-hidden">
                <div 
                  className="h-full bg-gradient-to-r from-cyan-400 to-purple-500"
                  style={{ width: `${profile.compatibility}%` }}
                ></div>
              </div>
              <p className="text-xs text-gray-400 mt-1">{profile.compatibility}% match</p>
            </div>
            
            {/* Interests */}
            <div className="mt-4 flex flex-wrap justify-center gap-2">
              {profile.interests.slice(0, 3).map(interest => (
                <span 
                  key={interest}
                  className="px-2 py-1 text-xs rounded-full bg-[rgba(0,240,255,0.1)] text-cyan-400"
                >
                  {interest}
                </span>
              ))}
            </div>
          </div>
        </div>
      </Link>
    </motion.div>
  );
};