export const ProfileAbout = ({ user }) => {
    return (
      <div className="bg-[rgba(255,255,255,0.05)] border border-[rgba(255,255,255,0.1)] rounded-2xl p-6 backdrop-blur-lg">
        <h2 className="text-xl font-semibold mb-4 text-cyan-400">About</h2>
        <p className="text-gray-300">{user.bio}</p>
        
        <div className="mt-6 grid grid-cols-2 gap-4">
          <div>
            <h3 className="text-sm text-gray-400">Education</h3>
            <p>{user.education}</p>
          </div>
          <div>
            <h3 className="text-sm text-gray-400">Work</h3>
            <p>{user.work}</p>
          </div>
          <div>
            <h3 className="text-sm text-gray-400">Languages</h3>
            <p>{user.languages.join(", ")}</p>
          </div>
          <div>
            <h3 className="text-sm text-gray-400">Relationship Status</h3>
            <p>{user.relationshipStatus}</p>
          </div>
        </div>
      </div>
    );
  };