import { motion } from "framer-motion";
import { useState } from "react";
import { FiMail, FiLock } from "react-icons/fi";

export const LoginForm = ({ onDemoLogin, onSuccess }) => {
  const [email, setEmail] = useState("");
  const [password, setPassword] = useState("");
  const [isLoading, setIsLoading] = useState(false);

  const handleSubmit = (e) => {
    e.preventDefault();
    setIsLoading(true);
    
    // Simulate API call
    setTimeout(() => {
      setIsLoading(false);
      onSuccess(); // This handles successful regular login
    }, 1500);
  };

  const handleDemoLoginClick = () => {
    setIsLoading(true);
    setTimeout(() => {
      setIsLoading(false);
      onDemoLogin(); // This handles demo login
    }, 1500);
  };

  return (
    <form onSubmit={handleSubmit} className="space-y-6">
      <div className="space-y-4">
        <div className="relative">
          <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
            <FiMail className="text-gray-400" />
          </div>
          <input
            type="email"
            placeholder="Email"
            value={email}
            onChange={(e) => setEmail(e.target.value)}
            className="w-full pl-10 pr-4 py-3 bg-[rgba(255,255,255,0.05)] border border-[rgba(255,255,255,0.1)] rounded-lg focus:outline-none focus:border-cyan-400 focus:ring-1 focus:ring-cyan-400/30 transition-all"
            required
          />
        </div>

        <div className="relative">
          <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
            <FiLock className="text-gray-400" />
          </div>
          <input
            type="password"
            placeholder="Password"
            value={password}
            onChange={(e) => setPassword(e.target.value)}
            className="w-full pl-10 pr-4 py-3 bg-[rgba(255,255,255,0.05)] border border-[rgba(255,255,255,0.1)] rounded-lg focus:outline-none focus:border-cyan-400 focus:ring-1 focus:ring-cyan-400/30 transition-all"
            required
          />
        </div>
      </div>

      <div className="flex items-center justify-between">
        <label className="flex items-center space-x-2 text-sm">
          <input 
            type="checkbox" 
            className="rounded bg-[rgba(255,255,255,0.05)] border-[rgba(255,255,255,0.1)]" 
          />
          <span>Remember me</span>
        </label>
        <button 
          type="button" 
          className="text-sm text-cyan-400 hover:underline"
        >
          Forgot password?
        </button>
      </div>

      <div className="space-y-3">
        <motion.button
          type="submit"
          disabled={isLoading}
          className="w-full py-3 rounded-lg bg-gradient-to-r from-cyan-400 to-blue-500 text-[#0A0F2A] font-medium hover:shadow-neon-cyan transition-all"
          whileTap={{ scale: 0.98 }}
        >
          {isLoading ? "Signing in..." : "Login"}
        </motion.button>

        <button
          type="button"
          onClick={handleDemoLoginClick}
          disabled={isLoading}
          className="w-full py-3 rounded-lg border border-pink-500 text-pink-400 font-medium hover:shadow-neon-pink transition-all"
        >
          {isLoading ? "Signing in..." : "Try Demo Account"}
        </button>
      </div>
    </form>
  );
};