export const ProfileInterests = ({ interests }) => {
    return (
      <div className="bg-[rgba(255,255,255,0.05)] border border-[rgba(255,255,255,0.1)] rounded-2xl p-6 backdrop-blur-lg">
        <h2 className="text-xl font-semibold mb-4 text-cyan-400">Interests</h2>
        
        <div className="flex flex-wrap gap-2">
          {interests.map((interest, index) => (
            <span 
              key={index}
              className="px-3 py-1.5 rounded-full bg-[rgba(0,240,255,0.1)] text-cyan-400 text-sm"
            >
              {interest}
            </span>
          ))}
        </div>
      </div>
    );
  };