import { BrowserRouter as Router, Routes, Route } from "react-router-dom";
import { Home } from "./pages/Home";
import { ViewProfile } from "./pages/Profile/ViewProfile";
import { EditProfile } from "./pages/Profile/EditProfile";
import { Dashboard } from "./pages/Dashboard";
import { Matches } from "./pages/Matches"; // 1. Import the Matches component

function App() {
  return (
    <Router>
      <Routes>
        <Route path="/" element={<Home />} />
        <Route path="/dashboard" element={<Dashboard />} />
        <Route path="/matches" element={<Matches />} /> {/* 2. Add the Matches route */}
        <Route path="/profile/edit" element={<EditProfile />} />
        <Route path="/profile/:userId" element={<ViewProfile />} />
      </Routes>
    </Router>
  );
}

export default App;