import React from 'react'; // Optional: Import React if needed by your setup

export const Footer = () => {
  return (
    <footer className="glass-effect border-t border-[rgba(255,255,255,0.1)] py-8 mt-12">
      <div className="container mx-auto px-4">
        <div className="flex flex-col md:flex-row justify-between items-center">
          {/* Left Side: Logo & Copyright */}
          <div className="flex items-center space-x-2 mb-4 md:mb-0">
            {/* You might want to update the logo text if needed */}
            <span className="text-cyan-400 font-bold text-xl">Luminous Connections</span>
            <span className="text-gray-400 text-sm">© {new Date().getFullYear()}</span>
          </div>

          {/* Middle: Quick Links */}
          <nav className="flex flex-wrap justify-center gap-4 mb-4 md:mb-0">
            {/* Use Link components from react-router-dom if these are internal links */}
            <a href="#" className="text-gray-400 hover:text-cyan-400 transition-colors">Privacy</a>
            <a href="#" className="text-gray-400 hover:text-cyan-400 transition-colors">Terms</a>
            <a href="#" className="text-gray-400 hover:text-cyan-400 transition-colors">FAQ</a>
            <a href="#" className="text-gray-400 hover:text-cyan-400 transition-colors">Contact</a>
          </nav>

          {/* Right Side: Social Icons */}
          {/* Ensure Font Awesome is loaded (e.g., via CDN in index.html or imported) */}
          <div className="flex space-x-4">
            <a href="#" className="text-gray-400 hover:text-cyan-400 transition-colors">
              <i className="fab fa-twitter"></i>
            </a>
            <a href="#" className="text-gray-400 hover:text-cyan-400 transition-colors">
              <i className="fab fa-instagram"></i>
            </a>
            <a href="#" className="text-gray-400 hover:text-cyan-400 transition-colors">
              <i className="fab fa-facebook"></i>
            </a>
          </div>
        </div>
      </div>
    </footer>
  );
};