import { motion } from "framer-motion";

export const ProfileGallery = ({ photos }) => {
  return (
    <div className="bg-[rgba(255,255,255,0.05)] border border-[rgba(255,255,255,0.1)] rounded-2xl p-6 backdrop-blur-lg">
      <h2 className="text-xl font-semibold mb-4 text-cyan-400">Gallery</h2>
      
      <div className="grid grid-cols-3 gap-3">
        {photos.map((photo, index) => (
          <motion.div 
            key={index}
            className="aspect-square bg-[rgba(255,255,255,0.1)] rounded-lg overflow-hidden"
            whileHover={{ scale: 1.03 }}
          >
            <img 
              src={photo} 
              className="w-full h-full object-cover"
              alt={`Gallery item ${index + 1}`}
            />
          </motion.div>
        ))}
      </div>
    </div>
  );
};