import { useState, useEffect } from 'react';
import { motion } from 'framer-motion';
import { Header } from '../components/Header'; // Adjusted import path
import { CosmicBackground } from '../components/CosmicBackground'; // Adjusted import path
import { ProfileCard } from '../components/ProfileCard'; // Adjusted import path
import { demoMatches } from '../data/demoMatches'; // Import demo data
import { Footer } from '../components/Footer';

export const Matches = () => {
  // Use demoMatches directly for now. In a real app, you'd fetch this.
  const [matches, setMatches] = useState(demoMatches);

  // Optional: Add logic here later to fetch actual matches if needed
  // useEffect(() => {
  //   // Fetch matches data based on the logged-in user
  //   // For now, we are using the demo data
  //   setMatches(demoMatches);
  // }, []);

  return (
    <div className="min-h-screen">
      {/* Background and Header */}
      <CosmicBackground />
      <Header />

      {/* Main Content */}
      <main className="container mx-auto px-4 py-12">
        <motion.h1
          className="text-3xl font-bold text-center mb-8 text-cyan-400"
          initial={{ opacity: 0, y: -20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5 }}
        >
          Based on your preferences ({matches.length} found)
        </motion.h1>

        {/* Matches Grid */}
        {matches.length > 0 ? (
          <motion.div
            className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6" // Adjusted grid columns for potentially more matches
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            transition={{ delay: 0.2, staggerChildren: 0.1 }}
          >
            {matches.map(profile => (
               <motion.div key={profile.id} initial={{ opacity: 0, y: 20 }} animate={{ opacity: 1, y: 0 }}>
                 <ProfileCard profile={profile} />
               </motion.div>
            ))}
          </motion.div>
        ) : (
          <motion.div
            className="text-center py-12"
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
          >
            <p className="text-gray-400">No matches found yet.</p>
            {/* Optional: Add a button to browse profiles or adjust preferences */}
            {/* <button className="mt-4 px-4 py-2 rounded-lg border border-cyan-400 text-cyan-400 hover:shadow-neon-cyan transition-all">
              Find More Profiles
            </button> */}
          </motion.div>
        )}
      </main>

      <Footer/>

    </div>
  );
};