import { motion } from "framer-motion";

export const ProfileHeader = ({ user }) => {
  return (
    <motion.div 
      className="relative bg-gradient-to-r from-[rgba(10,15,42,0.8)] to-[rgba(70,20,100,0.6)] rounded-2xl overflow-hidden border border-[rgba(255,255,255,0.1)]"
      initial={{ opacity: 0 }}
      animate={{ opacity: 1 }}
    >
      {/* Cover Photo */}
      <div className="h-48 bg-[rgba(0,240,255,0.1)] backdrop-blur-sm"></div>
      
      {/* Profile Info */}
      <div className="relative px-6 pb-6">
        <div className="flex items-end -mt-16 space-x-6">
          {/* Profile Picture */}
          <div className="relative">
            <img 
              src={user.photos[0]} 
              className="w-32 h-32 rounded-full border-4 border-[#0A0F2A] object-cover"
              alt={user.name}
            />
            <div className="absolute bottom-2 right-2 w-6 h-6 bg-green-500 rounded-full border-2 border-[#0A0F2A]"></div>
          </div>
          
          {/* Name & Basic Info */}
          <div className="flex-1">
            <h1 className="text-3xl font-bold text-white">{user.name}, {user.age}</h1>
            <p className="text-cyan-400">{user.profession}</p>
            <p className="text-gray-400 mt-1">{user.location}</p>
          </div>
          
          {/* Action Buttons */}
          <div className="flex space-x-3">
            <button className="px-4 py-2 rounded-lg bg-cyan-400 text-[#0A0F2A] font-medium hover:shadow-neon-cyan transition-all">
              Connect
            </button>
            <button className="px-4 py-2 rounded-lg border border-cyan-400 text-cyan-400 hover:shadow-neon-cyan transition-all">
              Message
            </button>
          </div>
        </div>
      </div>
    </motion.div>
  );
};