document.addEventListener('DOMContentLoaded', () => {

    // --- Navbar Toggle ---
    const navToggle = document.querySelector('.nav-toggle');
    const navLinks = document.querySelector('.nav-links');

    if (navToggle && navLinks) {
        navToggle.addEventListener('click', () => {
            navLinks.classList.toggle('active');
            // Optional: Change icon on toggle
            const icon = navToggle.querySelector('i');
            if (navLinks.classList.contains('active')) {
                icon.classList.remove('fa-bars');
                icon.classList.add('fa-times'); // X icon
            } else {
                icon.classList.remove('fa-times');
                icon.classList.add('fa-bars');
            }
        });
    }

    // --- Footer Current Year ---
    const currentYearSpan = document.getElementById('current-year');
    if (currentYearSpan) {
        currentYearSpan.textContent = new Date().getFullYear();
    }

    // --- Simple Form Validation (Example for Sign Up) ---
    const signupForm = document.getElementById('signup-form');
    if (signupForm) {
        signupForm.addEventListener('submit', function(event) {
            event.preventDefault(); // Prevent actual submission for demo
            let isValid = true;

            // Clear previous errors
            this.querySelectorAll('.error-message').forEach(span => span.textContent = '');
            this.querySelectorAll('.error').forEach(el => el.classList.remove('error'));

            // Helper to show error
            const showError = (inputId, message) => {
                const input = this.querySelector(`#${inputId}`);
                const errorSpan = input.nextElementSibling; // Assumes error span is immediate sibling
                if (input && errorSpan && errorSpan.classList.contains('error-message')) {
                    input.classList.add('error');
                    errorSpan.textContent = message;
                    isValid = false; // Mark form as invalid
                } else {
                    console.error(`Could not find input or error span for ${inputId}`);
                }
            };

            // --- Validation Checks ---
            const fullname = this.querySelector('#fullname');
            if (fullname && fullname.value.trim() === '') {
                showError('fullname', 'Full Name is required.');
            }

            const gender = this.querySelector('#gender');
            if (gender && gender.value === '') {
                showError('gender', 'Please select your gender.');
            }

            const dob = this.querySelector('#dob');
             if (dob && dob.value === '') {
                showError('dob', 'Date of Birth is required.');
            }

             const religion = this.querySelector('#religion');
             if (religion && religion.value === '') {
                showError('religion', 'Please select your religion.');
            }

             const language = this.querySelector('#language');
             if (language && language.value.trim() === '') {
                showError('language', 'Mother Tongue is required.');
            }

            const email = this.querySelector('#email');
            if (email && email.value.trim() === '') {
                showError('email', 'Email is required.');
            } else if (email && !/\S+@\S+\.\S+/.test(email.value)) { // Basic email format
                showError('email', 'Please enter a valid email address.');
            }

            const password = this.querySelector('#password');
            if (password && password.value.trim() === '') {
                showError('password', 'Password is required.');
            } else if (password && password.value.length < 6) {
                showError('password', 'Password must be at least 6 characters long.');
            }

            // --- If Valid (For Demo) ---
            if (isValid) {
                alert('Sign Up form submitted successfully! (Demo)');
                // In a real app, you would send data to the server here
                // this.submit(); // Uncomment to allow actual submission if needed
            } else {
                 alert('Please correct the errors in the form.');
            }
        });
    }

    // --- Mock Dashboard Tab Switching ---
    const tabButtons = document.querySelectorAll('.dashboard-tabs .tab-button');
    const tabContents = document.querySelectorAll('.dashboard-content .tab-content');

    if (tabButtons.length > 0 && tabContents.length > 0) {
        tabButtons.forEach(button => {
            button.addEventListener('click', () => {
                const targetTab = button.getAttribute('data-tab');

                // Deactivate all buttons and contents
                tabButtons.forEach(btn => btn.classList.remove('active'));
                tabContents.forEach(content => {
                    content.classList.remove('active');
                    content.style.display = 'none'; // Hide content
                });

                // Activate the clicked button and corresponding content
                button.classList.add('active');
                const activeContent = document.getElementById(`${targetTab}-content`);
                if (activeContent) {
                    activeContent.classList.add('active');
                    activeContent.style.display = 'block'; // Show content
                }
            });
        });
    }

}); // End DOMContentLoaded

// --- Admin Panel Functionality ---
document.addEventListener('DOMContentLoaded', () => {

    // Check if we are on the admin page
    const adminPanel = document.querySelector('.admin-panel');
    if (adminPanel) {

        const sidebarLinks = adminPanel.querySelectorAll('.sidebar-nav .nav-link:not(.logout-link)');
        const contentSections = adminPanel.querySelectorAll('.admin-content-area .admin-content');
        const menuToggle = document.getElementById('admin-menu-toggle');
        const sidebar = adminPanel.querySelector('.admin-sidebar');

        // --- Sidebar Navigation ---
        sidebarLinks.forEach(link => {
            link.addEventListener('click', (event) => {
                event.preventDefault(); // Prevent default anchor behavior

                const targetId = link.getAttribute('href').substring(1); // Get ID like 'dashboard-content'
                const targetSection = document.getElementById(targetId);

                // Deactivate all links and sections
                sidebarLinks.forEach(l => l.classList.remove('active'));
                contentSections.forEach(section => {
                    section.classList.remove('active');
                    section.style.display = 'none'; // Hide section
                });

                // Activate clicked link and target section
                link.classList.add('active');
                if (targetSection) {
                    targetSection.classList.add('active');
                    targetSection.style.display = 'block'; // Show section
                }

                 // Close sidebar on mobile after clicking a link
                 if (window.innerWidth <= 768 && sidebar.classList.contains('open')) {
                     sidebar.classList.remove('open');
                 }
            });
        });

        // --- Responsive Sidebar Toggle ---
        if (menuToggle && sidebar) {
            menuToggle.addEventListener('click', () => {
                sidebar.classList.toggle('open');
            });

             // Optional: Close sidebar if clicking outside of it on mobile
             document.addEventListener('click', (event) => {
                 if (window.innerWidth <= 768 && sidebar.classList.contains('open')) {
                     // Check if the click was outside the sidebar and not on the toggle button
                     if (!sidebar.contains(event.target) && !menuToggle.contains(event.target)) {
                         sidebar.classList.remove('open');
                     }
                 }
             });
        }

        // Ensure the default active section is displayed on load
        const initialActiveLink = adminPanel.querySelector('.sidebar-nav .nav-link.active');
        if (initialActiveLink) {
             const initialTargetId = initialActiveLink.getAttribute('href').substring(1);
             const initialTargetSection = document.getElementById(initialTargetId);
             if (initialTargetSection) {
                  contentSections.forEach(section => {
                      section.style.display = 'none'; // Hide all first
                      section.classList.remove('active');
                  });
                 initialTargetSection.style.display = 'block'; // Show default
                 initialTargetSection.classList.add('active');
             }
        }
    } // End if(adminPanel)

}); // End DOMContentLoaded (ensure only one wrapper if already present)