document.addEventListener("DOMContentLoaded", function () {
  // Mobile Menu Toggle
  const menuToggle = document.querySelector(".menu-toggle");
  const navLinks = document.querySelector(".nav-links");

  menuToggle.addEventListener("click", function () {
    navLinks.classList.toggle("active");
    menuToggle.querySelector("i").classList.toggle("fa-times");
    menuToggle.querySelector("i").classList.toggle("fa-bars");
  });

  // Smooth Scrolling for Navigation
  document.querySelectorAll('a[href^="#"]').forEach((anchor) => {
    anchor.addEventListener("click", function (e) {
      e.preventDefault();

      navLinks.classList.remove("active");
      menuToggle.querySelector("i").classList.remove("fa-times");
      menuToggle.querySelector("i").classList.add("fa-bars");

      const targetId = this.getAttribute("href");
      const targetElement = document.querySelector(targetId);

      window.scrollTo({
        top: targetElement.offsetTop - 80,
        behavior: "smooth",
      });
    });
  });

  // Initialize Portfolio Grid with working images
  const portfolioGrid = document.querySelector(".portfolio-grid");
  const portfolioData = [
    {
        image: "https://images.pexels.com/photos/2065195/pexels-photo-2065195.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2",
        category: "editorial",
        title: "Vogue Editorial"
      },
    {
      image:
        "https://images.unsplash.com/photo-1515886657613-9f3515b0c78f?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=600&q=80",
      category: "bridal",
      title: "Modern Bride",
    },
    {
      image:
        "https://images.unsplash.com/photo-1544005313-94ddf0286df2?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=600&q=80",
      category: "celebrity",
      title: "Award Show Glam",
    },
    {
      image:
        "https://images.pexels.com/photos/5119214/pexels-photo-5119214.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2",
      category: "fantasy",
      title: "Fantasy Creation",
    },
    {
      image:
        "https://images.unsplash.com/photo-1529626455594-4ff0802cfb7e?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=600&q=80",
      category: "editorial",
      title: "Harper's Bazaar",
    },
    {
      image:
        "https://images.unsplash.com/photo-1524504388940-b1c1722653e1?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=600&q=80",
      category: "bridal",
      title: "Traditional Bride",
    },
    {
      image:
        "https://images.unsplash.com/photo-1534528741775-53994a69daeb?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=600&q=80",
      category: "celebrity",
      title: "Movie Premiere",
    },
    {
      image:
        "https://images.unsplash.com/photo-1488426862026-3ee34a7d66df?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=600&q=80",
      category: "fantasy",
      title: "Avant Garde",
    },
  ];

  // Clear existing content
  portfolioGrid.innerHTML = "";

  // Create portfolio items
  portfolioData.forEach((item) => {
    const portfolioItem = document.createElement("div");
    portfolioItem.className = `portfolio-item ${item.category}`;
    portfolioItem.style.backgroundImage = `url(${item.image})`;

    const portfolioInfo = document.createElement("div");
    portfolioInfo.className = "portfolio-info";
    portfolioInfo.innerHTML = `
        <p class="portfolio-category">${item.category.toUpperCase()}</p>
        <h3 class="portfolio-title">${item.title}</h3>
        <a href="#" class="view-more">View Details</a>
    `;

    portfolioItem.appendChild(portfolioInfo);
    portfolioGrid.appendChild(portfolioItem);
  });

  // Portfolio Filter Functionality
  const filterButtons = document.querySelectorAll(".filter-btn");
  const portfolioItems = document.querySelectorAll(".portfolio-item");

  filterButtons.forEach((button) => {
    button.addEventListener("click", function () {
      // Remove active class from all buttons
      filterButtons.forEach((btn) => btn.classList.remove("active"));
      // Add active class to clicked button
      this.classList.add("active");

      const filterValue = this.getAttribute("data-filter");

      portfolioItems.forEach((item) => {
        if (filterValue === "all" || item.classList.contains(filterValue)) {
          item.style.display = "block";
        } else {
          item.style.display = "none";
        }
      });
    });
  });

  // Initialize Instagram Feed with placeholder images
  const instagramFeed = document.getElementById("instagramFeed");
  const placeholderImages = [
    "https://images.unsplash.com/photo-1596462502278-27bfdc403348?w=500&auto=format&fit=crop",
    "https://images.unsplash.com/photo-1529626455594-4ff0802cfb7e?w=500&auto=format&fit=crop",
    "https://images.unsplash.com/photo-1534528741775-53994a69daeb?w=500&auto=format&fit=crop",
    "https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=500&auto=format&fit=crop",
    "https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=500&auto=format&fit=crop",
    "https://images.unsplash.com/photo-1544005313-94ddf0286df2?w=500&auto=format&fit=crop",
    "https://images.unsplash.com/photo-1554151228-14d9def656e4?w=500&auto=format&fit=crop",
    "https://images.unsplash.com/photo-1542206395-9feb3edaa68d?w=500&auto=format&fit=crop",
    "https://images.unsplash.com/photo-1503104834685-7205e8607eb9?w=500&auto=format&fit=crop",
  ];

  placeholderImages.forEach((imageUrl) => {
    const item = document.createElement("div");
    item.className = "instagram-item";
    item.style.backgroundImage = `url(${imageUrl})`;
    item.innerHTML = '<i class="fas fa-heart"></i>';
    instagramFeed.appendChild(item);
  });

  // Animate skill bars
  const skillBars = document.querySelectorAll(".skill-bar");

  function animateSkillBars() {
    skillBars.forEach((bar) => {
      const level = bar.getAttribute("data-level");
      bar.style.width = "0";
      setTimeout(() => {
        bar.style.width = `${level}%`;
      }, 100);
    });
  }
  // Skill bar animation - Add this to your existing main.js
  function animateSkillBars() {
    document.querySelectorAll(".skill-bar").forEach((bar) => {
      const level = bar.getAttribute("data-level");
      bar.style.width = "0";
      setTimeout(() => {
        bar.style.width = `${level}%`;
      }, 100);
    }); // Animate skill bars when visible
    function animateSkillBars() {
      document.querySelectorAll(".skill-bar").forEach((bar) => {
        const level = bar.getAttribute("data-level");
        bar.style.width = "0"; // Reset before animating

        setTimeout(() => {
          bar.style.width = `${level}%`;
          bar.classList.add("animate"); // Add glow animation
        }, 100);
      });
    }

    // Intersection Observer for scroll-triggered animation
    const skillObserver = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            animateSkillBars();
            skillObserver.disconnect();
          }
        });
      },
      { threshold: 0.3 }
    );

    // Observe the artists section
    const artistsSection = document.querySelector(".artists-section");
    if (artistsSection) {
      skillObserver.observe(artistsSection);
    }
  }

  // Call this function when the artists section is in view
  const artistObserver = new IntersectionObserver(
    (entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          animateSkillBars();
          artistObserver.disconnect();
        }
      });
    },
    { threshold: 0.5 }
  );

  artistObserver.observe(document.querySelector(".artists-section"));

  // Intersection Observer for animations
  const observerOptions = {
    threshold: 0.1,
  };

  const observer = new IntersectionObserver((entries) => {
    entries.forEach((entry) => {
      if (entry.isIntersecting) {
        if (entry.target.classList.contains("artists-grid")) {
          animateSkillBars();
        }
        entry.target.classList.add("animated");
      }
    });
  }, observerOptions);

  document
    .querySelectorAll(".artists-grid, .service-card, .portfolio-item")
    .forEach((section) => {
      observer.observe(section);
    });

  // Simple Parallax Effect
  window.addEventListener("scroll", function () {
    const scrollPosition = window.pageYOffset;
    const parallaxBg = document.querySelector(".parallax-bg");

    if (parallaxBg) {
      parallaxBg.style.transform = `translateY(${scrollPosition * 0.5}px)`;
    }

    const services = document.querySelector(".services");
    if (services) {
      const servicesPosition = services.getBoundingClientRect().top;
      if (servicesPosition < window.innerHeight && servicesPosition > 0) {
        const serviceCards = document.querySelectorAll(".service-card");
        serviceCards.forEach((card, index) => {
          const speed = 0.1 + index * 0.05;
          card.style.transform = `translateY(${scrollPosition * speed}px)`;
        });
      }
    }
  });

  // Service Card Interactions
  document.querySelectorAll(".service-btn").forEach((button) => {
    button.addEventListener("click", function (e) {
      e.preventDefault();
      const serviceName =
        this.closest(".service-card").querySelector("h3").textContent;
      alert(`You've selected ${serviceName}. Redirecting to booking page...`);
      // In production, replace with actual booking functionality
    });
  });

  // Form validation
  const contactForm = document.querySelector(".contact-form");
  if (contactForm) {
    contactForm.addEventListener("submit", function (e) {
      e.preventDefault();

      // Validate form fields
      const nameInput = this.querySelector('input[type="text"]');
      const emailInput = this.querySelector('input[type="email"]');
      const messageInput = this.querySelector("textarea");

      if (!nameInput.value || !emailInput.value || !messageInput.value) {
        alert("Please fill in all fields");
        return;
      }

      if (!emailInput.value.includes("@")) {
        alert("Please enter a valid email address");
        return;
      }

      // Form is valid - submit or show success
      alert("Message sent successfully!");
      this.reset();
    });
  }
});
